package ru.yandex.direct.mysql.ytsync.task.instances;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.direct.binlogbroker.replicatetoyt.SchemaManager;
import ru.yandex.direct.mysql.ytsync.common.keys.PivotKeys;
import ru.yandex.direct.mysql.ytsync.task.builders.JooqTaskBuilder;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTableConnections;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTask;
import ru.yandex.direct.mysql.ytsync.task.config.DirectYtSyncConfig;
import ru.yandex.direct.mysql.ytsync.task.provider.TaskProvider;
import ru.yandex.direct.mysql.ytsync.util.FieldValuesParser;

import static ru.yandex.direct.dbschema.ppc.Tables.ADGROUPS_INTERNAL;
import static ru.yandex.direct.dbschema.ppc.Tables.AGGR_STATUSES_ADGROUPS;
import static ru.yandex.direct.dbschema.ppc.Tables.PHRASES;
import static ru.yandex.direct.dbschema.ppc.tables.AdgroupsCpmBanner.ADGROUPS_CPM_BANNER;

@Lazy
@Component
@ParametersAreNonnullByDefault
public class PhrasesTask extends TaskProvider {
    private static final int PARTITIONS = 64;
    private static final PivotKeys PIVOT_KEYS = PivotKeys.hashModPartitions(PARTITIONS);

    private static final String FIELD_AGGR_DATA_NAME = "aggr_data";
    private static final String FIELD_START_TIME_NAME = "start_time";
    private static final String FIELD_FINISH_TIME_NAME = "finish_time";

    private static final SyncTableConnections TABLE_CONNECTIONS =
            new SyncTableConnections(PHRASES.getName(), PHRASES.PID.getName())
                    .leftJoin(ADGROUPS_CPM_BANNER.getName(), ADGROUPS_CPM_BANNER.PID.getName())
                    .leftJoin(AGGR_STATUSES_ADGROUPS.getName(), AGGR_STATUSES_ADGROUPS.PID.getName())
                    .leftJoin(ADGROUPS_INTERNAL.getName(), ADGROUPS_INTERNAL.PID.getName());
    private static final SyncTask PHRASES_TASK =
            new JooqTaskBuilder(TABLE_CONNECTIONS, DirectYtSyncConfig::phrasesPath, PIVOT_KEYS)
                    .expressionKey("__hash__",
                            SchemaManager.getHashColumnExpression(List.of(PHRASES.CID.getName()), PARTITIONS)
                    )
                    .longKey(PHRASES.CID)
                    .longKey(PHRASES.PID, 2)
                    .shardKey("__shard__", 1)
                    .enumField(PHRASES.ADGROUP_TYPE)
                    .field(PHRASES.GEO)
                    .field(PHRASES.GROUP_NAME)
                    .enumField(PHRASES.STATUS_MODERATE)
                    .enumField(PHRASES.STATUS_BS_SYNCED)
                    .enumField(PHRASES.STATUS_AUTOBUDGET_SHOW)
                    .enumField(PHRASES.STATUS_SHOWS_FORECAST)
                    .enumField(PHRASES.STATUS_POST_MODERATE)
                    .enumField(ADGROUPS_CPM_BANNER.CRITERION_TYPE)
                    .ysonField(AGGR_STATUSES_ADGROUPS.AGGR_DATA, FIELD_AGGR_DATA_NAME, FieldValuesParser::toJsonString)
                    .dateTimeField(ADGROUPS_INTERNAL.START_TIME, FIELD_START_TIME_NAME,
                            FieldValuesParser::toLongFromLocalDateTime)
                    .dateTimeField(ADGROUPS_INTERNAL.FINISH_TIME, FIELD_FINISH_TIME_NAME,
                            FieldValuesParser::toLongFromLocalDateTime)
                    .build();

    public PhrasesTask() {
        super(PHRASES_TASK, 50L);
    }
}
