package ru.yandex.direct.mysql.ytsync.task.instances;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.direct.mysql.ytsync.common.keys.PivotKeys;
import ru.yandex.direct.mysql.ytsync.task.builders.JooqTaskBuilder;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTableConnections;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTask;
import ru.yandex.direct.mysql.ytsync.task.config.DirectYtSyncConfig;
import ru.yandex.direct.mysql.ytsync.task.provider.TaskProvider;

import static ru.yandex.direct.dbschema.ppc.tables.RecommendationsOnline.RECOMMENDATIONS_ONLINE;

@Lazy
@Component
@ParametersAreNonnullByDefault
public class RecommendationsOnlineTask extends TaskProvider {
    private static final PivotKeys PIVOT_KEYS = PivotKeys.singlePartition();

    private static final SyncTableConnections TABLE_CONNECTIONS =
            new SyncTableConnections(RECOMMENDATIONS_ONLINE.getName(), RECOMMENDATIONS_ONLINE.CLIENT_ID.getName());

    private static final SyncTask RECOMMENDATIONS_ONLINE_TASK =
            new JooqTaskBuilder(TABLE_CONNECTIONS, DirectYtSyncConfig::recommendationsOnlinePath, PIVOT_KEYS)
                    .longKey(RECOMMENDATIONS_ONLINE.CLIENT_ID, "client_id")
                    .longKey(RECOMMENDATIONS_ONLINE.TYPE, "type")
                    .longKey(RECOMMENDATIONS_ONLINE.CID, "cid")
                    .longKey(RECOMMENDATIONS_ONLINE.PID, "pid")
                    .longKey(RECOMMENDATIONS_ONLINE.BID, "bid")
                    .stringKey(RECOMMENDATIONS_ONLINE.USER_KEY_1, "user_key_1")
                    .stringKey(RECOMMENDATIONS_ONLINE.USER_KEY_2, "user_key_2")
                    .stringKey(RECOMMENDATIONS_ONLINE.USER_KEY_3, "user_key_3")
                    .longKey(RECOMMENDATIONS_ONLINE.TIMESTAMP, "timestamp")
                    .stringField(RECOMMENDATIONS_ONLINE.DATA, "data")
                    .build();

    public RecommendationsOnlineTask() {
        super(RECOMMENDATIONS_ONLINE_TASK, 10L);
    }
}
