package ru.yandex.direct.mysql.ytsync.task.instances;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.direct.mysql.ytsync.common.keys.PivotKeys;
import ru.yandex.direct.mysql.ytsync.task.builders.JooqTaskBuilder;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTableConnections;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTask;
import ru.yandex.direct.mysql.ytsync.task.config.DirectYtSyncConfig;
import ru.yandex.direct.mysql.ytsync.task.provider.TaskProvider;

import static ru.yandex.direct.dbschema.ppc.tables.RecommendationsStatus.RECOMMENDATIONS_STATUS;

@Lazy
@Component
@ParametersAreNonnullByDefault
public class RecommendationsStatusTask extends TaskProvider {
    private static final PivotKeys PIVOT_KEYS = PivotKeys.singlePartition();

    private static final SyncTableConnections TABLE_CONNECTIONS =
            new SyncTableConnections(RECOMMENDATIONS_STATUS.getName(), RECOMMENDATIONS_STATUS.CLIENT_ID.getName());

    private static final SyncTask RECOMMENDATIONS_STATUS_TASK =
            new JooqTaskBuilder(TABLE_CONNECTIONS, DirectYtSyncConfig::recommendationsStatusPath, PIVOT_KEYS)
                    .longKey(RECOMMENDATIONS_STATUS.CLIENT_ID, "client_id")
                    .longKey(RECOMMENDATIONS_STATUS.TYPE, "type")
                    .longKey(RECOMMENDATIONS_STATUS.CID, "cid")
                    .longKey(RECOMMENDATIONS_STATUS.PID, "pid")
                    .longKey(RECOMMENDATIONS_STATUS.BID, "bid")
                    .stringKey(RECOMMENDATIONS_STATUS.USER_KEY_1, "user_key_1")
                    .stringKey(RECOMMENDATIONS_STATUS.USER_KEY_2, "user_key_2")
                    .stringKey(RECOMMENDATIONS_STATUS.USER_KEY_3, "user_key_3")
                    .longKey(RECOMMENDATIONS_STATUS.TIMESTAMP, "timestamp")
                    .enumField(RECOMMENDATIONS_STATUS.STATUS, "status")
                    .build();

    public RecommendationsStatusTask() {
        super(RECOMMENDATIONS_STATUS_TASK, 10L);
    }
}
