package ru.yandex.direct.mysql.ytsync.task.instances;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.direct.binlogbroker.replicatetoyt.SchemaManager;
import ru.yandex.direct.mysql.ytsync.common.keys.PivotKeys;
import ru.yandex.direct.mysql.ytsync.task.builders.JooqTaskBuilder;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTableConnections;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTask;
import ru.yandex.direct.mysql.ytsync.task.config.DirectYtSyncConfig;
import ru.yandex.direct.mysql.ytsync.task.provider.TaskProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.RETARGETING_CONDITIONS;

@Lazy
@Component
@ParametersAreNonnullByDefault
public class RetargetingConditionsTask extends TaskProvider {
    private static final int PARTITIONS = 64;
    private static final PivotKeys PIVOT_KEYS = PivotKeys.hashModPartitions(PARTITIONS);

    private static final SyncTableConnections TABLE_CONNECTIONS =
            new SyncTableConnections(RETARGETING_CONDITIONS.getName(), RETARGETING_CONDITIONS.RET_COND_ID.getName());
    private static final SyncTask RETARGETING_CONDITIONS_TASK =
            new JooqTaskBuilder(TABLE_CONNECTIONS, DirectYtSyncConfig::retargetingConditionsPath, PIVOT_KEYS)
                    .expressionKey("__hash__",
                            SchemaManager.getHashColumnExpression(List.of(RETARGETING_CONDITIONS.CLIENT_ID.getName()), PARTITIONS)
                    )
                    .longKey(RETARGETING_CONDITIONS.RET_COND_ID)
                    .longKey(RETARGETING_CONDITIONS.CLIENT_ID)
                    .shardKey("__shard__", 1)
                    .field(RETARGETING_CONDITIONS.CONDITION_NAME)
                    .field(RETARGETING_CONDITIONS.CONDITION_DESC)
                    .field(RETARGETING_CONDITIONS.CONDITION_JSON)
                    .field(RETARGETING_CONDITIONS.IS_DELETED)
                    .dateTimeField(RETARGETING_CONDITIONS.MODTIME)
                    .enumField(RETARGETING_CONDITIONS.RETARGETING_CONDITIONS_TYPE)
                    .field(RETARGETING_CONDITIONS.REACH)
                    .numFlagSetField(RETARGETING_CONDITIONS.PROPERTIES, "negative", "negative")
                    .numFlagSetField(RETARGETING_CONDITIONS.PROPERTIES, "interest", "interest")
                    .numFlagSetField(RETARGETING_CONDITIONS.PROPERTIES, "autoretargeting", "autoretargeting")
                    .build();

    public RetargetingConditionsTask() {
        super(RETARGETING_CONDITIONS_TASK, 50L);
    }
}
