package ru.yandex.direct.mysql.ytsync.task.instances;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.direct.binlogbroker.replicatetoyt.SchemaManager;
import ru.yandex.direct.mysql.ytsync.common.keys.PivotKeys;
import ru.yandex.direct.mysql.ytsync.task.builders.JooqTaskBuilder;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTableConnections;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTask;
import ru.yandex.direct.mysql.ytsync.task.config.DirectYtSyncConfig;
import ru.yandex.direct.mysql.ytsync.task.provider.TaskProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.TAG_CAMPAIGN_LIST;
import static ru.yandex.direct.dbschema.ppc.Tables.TAG_GROUP;

@Lazy
@Component
@ParametersAreNonnullByDefault
public class TagGroupTask extends TaskProvider {
    private static final int PARTITIONS = 64;
    private static final PivotKeys PIVOT_KEYS = PivotKeys.hashModPartitions(PARTITIONS);

    private static final SyncTableConnections TABLE_CONNECTIONS =
            new SyncTableConnections(TAG_GROUP.getName(), TAG_GROUP.TAG_ID.getName())
                    .leftJoin(TAG_CAMPAIGN_LIST.getName(), TAG_CAMPAIGN_LIST.TAG_ID.getName());

    private static final SyncTask TAG_GROUP_TASK =
            new JooqTaskBuilder(TABLE_CONNECTIONS, DirectYtSyncConfig::tagGroupPath, PIVOT_KEYS)
                    .expressionKey("__hash__",
                            SchemaManager.getHashColumnExpression(List.of(TAG_GROUP.PID.getName()), PARTITIONS)
                    )
                    .longKey(TAG_GROUP.PID)
                    .longKey(TAG_GROUP.TAG_ID)
                    .shardKey("__shard__", 1)
                    // На момент написания поле не использовалось. Добавил чтобы таблица была динамической (у
                    // динамических таблиц должно быть хотя бы одно неключевое поле)
                    .stringField(TAG_CAMPAIGN_LIST.TAG_NAME, TAG_CAMPAIGN_LIST.TAG_NAME.getName())
                    .build();

    public TagGroupTask() {
        super(TAG_GROUP_TASK, 50L);
    }
}
