package ru.yandex.direct.mysql.ytsync.task.provider;

import java.util.Collections;
import java.util.function.Predicate;

import ru.yandex.direct.mysql.MySQLSimpleRow;
import ru.yandex.direct.mysql.ytsync.common.compatibility.YtSupport;
import ru.yandex.direct.mysql.ytsync.export.task.TableExportTask;
import ru.yandex.direct.mysql.ytsync.export.task.TableExportTemplate;
import ru.yandex.direct.mysql.ytsync.export.util.valueprocessing.ExportFlatRowCreator;
import ru.yandex.direct.mysql.ytsync.synchronizator.tables.Table;
import ru.yandex.direct.mysql.ytsync.synchronizator.tables.TableBase;
import ru.yandex.direct.mysql.ytsync.synchronizator.tables.TableBaseWithIndex;
import ru.yandex.direct.mysql.ytsync.task.builders.SyncTask;
import ru.yandex.direct.mysql.ytsync.task.config.DirectYtSyncConfig;
import ru.yandex.yt.ytclient.tables.TableSchema;

public class TaskProvider {
    private final SyncTask syncTask;
    private final Long taskSize;

    public TaskProvider(SyncTask syncTask, Long taskSize) {
        this.syncTask = syncTask;
        this.taskSize = taskSize;
    }

    public Table constructTable(YtSupport yt, DirectYtSyncConfig config) {
        if (syncTask.hasIndexTable()) {
            return new TableBaseWithIndex(yt, syncTask.getTablePath(config), syncTask.getTableSchema(),
                    createIndexTable(yt, syncTask.getIndexTablePath(config), syncTask.getIndexSchema()));
        } else {
            return new TableBase(yt, syncTask.getTablePath(config), syncTask.getTableSchema());
        }
    }

    public TableExportTemplate constructTableExportTemplate(DirectYtSyncConfig config) {
        return new TableExportTemplate(
                Collections.singletonList(syncTask.getMainTableName()),
                syncTask.getTablePath(config),
                syncTask.getTableSchema(),
                syncTask.getTablePivotKeys()
        );
    }

    public TableExportTemplate constructIndexExportTemplate(DirectYtSyncConfig config) {
        if (!syncTask.hasIndexTable()) {
            return null;
        }
        return new TableExportTemplate(
                syncTask.getTablePath(config),
                syncTask.getIndexTablePath(config),
                syncTask.getIndexSchema()
        );
    }

    public TableExportTask constructTableExportTask() {
        return new TableExportTask(
                syncTask.getSqlTemplate(),
                syncTask.getMainTableName(),
                syncTask.getMainIdColumn(),
                syncTask.getTableSchema(),
                getFlatRowCreator()
        );
    }

    private ExportFlatRowCreator getFlatRowCreator() {
        return new ExportFlatRowCreator(syncTask.getTableSchema(), syncTask.getExportTableFieldProcessors(),
                syncTask.getExportAdditionalFields());
    }

    private static Table createIndexTable(YtSupport yt, String indexSchemaPath, TableSchema indexSchema) {
        // Сейчас запросов в индекс в норме быть не должно, используем SCAN
        return new TableBase(yt, indexSchemaPath, indexSchema);
    }

    public SyncTask getSyncTask() {
        return syncTask;
    }

    public Long getTaskSize() {
        return taskSize;
    }

    public String getMainTable() {
        return syncTask.getMainTableName();
    }

    public boolean hasSkipPredicate() {
        return syncTask.hasSkipPredicate();
    }

    public Predicate<MySQLSimpleRow> getSkipPredicate() {
        return syncTask.getSkipPredicate();
    }
}
