package ru.yandex.direct.mysql.ytsync.util;

import java.time.LocalDate;
import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.mysql.ytsync.common.model.JsonString;
import ru.yandex.direct.utils.DateTimeUtils;
import ru.yandex.direct.utils.JsonUtils;

import static ru.yandex.direct.utils.JsonUtils.toJson;

@ParametersAreNonnullByDefault
public class CampaignsParser {

    private static final Logger logger = LoggerFactory.getLogger(CampaignsParser.class);

    /**
     * Конвертирует строку {@param strategyData} в JsonString (чтобы отличить, при добавлении в Yt, от String типа)
     * для дальнейшей конвертации в Yson формат.
     * В методе также происходит добавление в json нового поля finish_time для сохранения date finish поля в секундах.
     * Поле finish_time используется в условиях запросов, для фильтра объектов по статусам.
     */
    @Nullable
    public static JsonString convertStrategyDataToJsonString(@Nullable String strategyData) {
        if (Strings.isNullOrEmpty(strategyData)) {
            return null;
        }
        Map<String, Object> deserializedJson = JsonUtils.fromJson(strategyData, Map.class);
        String finish = (String) deserializedJson.get("finish");
        if (finish != null) {
            try {
                LocalDate localDateFinish = LocalDate.parse(finish);
                deserializedJson.put("finish_time",
                        localDateFinish.atStartOfDay().atZone(DateTimeUtils.MSK).toEpochSecond());
            } catch (RuntimeException e) {
                logger.error("Can't parse {} as LocalDate", finish, e);
            }
        }
        return new JsonString(toJson(deserializedJson));
    }
}
