package ru.yandex.direct.mysql.ytsync.util;

import java.time.LocalDate;
import java.time.LocalDateTime;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.mysql.ytsync.common.model.JsonString;
import ru.yandex.direct.utils.DateTimeUtils;

@ParametersAreNonnullByDefault
public class FieldValuesParser {

    /**
     * Для преобразования String в объект JsonString для отличия обычной строки от json,
     * для последующей конвертации в yson (при синхронизации данных в Yt таблицу)
     */
    @Nullable
    public static JsonString toJsonString(@Nullable String json) {
        return json != null ? new JsonString(json) : null;
    }

    /**
     * Для преобразования LocalDate в Long. На момент написания, в Java Yt клиенте не было поддержки date типа,
     * поэтому переводим в long, для дальнейшей возможности использования в условиях запросов
     */
    @Nullable
    public static Long toLongFromLocalDate(@Nullable LocalDate localDate) {
        return localDate != null
                ? localDate.atStartOfDay().atZone(DateTimeUtils.MSK).toEpochSecond()
                : null;
    }

    /**
     * Для преобразования LocalDateTime в Long. На момент написания, в Java Yt клиенте не было поддержки date типа,
     * поэтому переводим в long, для дальнейшей возможности использования в условиях запросов
     */
    @Nullable
    public static Long toLongFromLocalDateTime(@Nullable LocalDateTime localDateTime) {
        return localDateTime != null
                ? localDateTime.atZone(DateTimeUtils.MSK).toEpochSecond()
                : null;
    }

}
