package ru.yandex.direct.mysql.ytsync.util;

import java.util.Arrays;

import javax.annotation.Nullable;

public class KeywordsParser {
    private static final String NO_KEYWORD = "";

    private KeywordsParser() {
    }

    /**
     * Получить плюс-часть ключевой фразы
     *
     * @param keywordString строка с ключевой фразой
     */
    public static String getPlainKeyword(@Nullable String keywordString) {
        if (keywordString == null) {
            return NO_KEYWORD;
        }

        String[] mwords = keywordString.split("\\s+-");
        return mwords[0];
    }

    /**
     * Получить список минус-фраз ключевой фразы
     *
     * @param keywordString строка с ключевой фразой
     */
    public static String getMinusKeywords(@Nullable String keywordString) {
        if (keywordString == null) {
            return NO_KEYWORD;
        }
        String[] mwords = keywordString.split("\\s+-");

        return String.join(";", Arrays.copyOfRange(mwords, 1, mwords.length));
    }
}
