JUNIT5()

INCLUDE(${ARCADIA_ROOT}/direct/libs/common.inc)
WITH_KOTLIN()

SIZE(MEDIUM)
TAG(ya:not_autocheck)

OWNER(g:direct)

SET(react_version 17.0.2)

PEERDIR(
    contrib/java/org/aspectj/aspectjrt
    contrib/java/org/aspectj/aspectjweaver

    direct/common
    direct/core
    direct/core/ut
    direct/libs/utils
    direct/libs/clickhouse-utils
    direct/libs/jcommander-utils
    direct/libs/solomon

    direct/libs-internal/graphql
    direct/libs-internal/grid-processing
    direct/libs-internal/internaltools
    direct/libs-internal/internaltools-core
    direct/libs-internal/web-core
    direct/libs-internal/yt-core

    contrib/java/io/springfox/springfox-swagger2
    contrib/java/io/springfox/springfox-swagger-ui

    contrib/java/org/springframework/spring-core
    contrib/java/org/springframework/spring-context
    contrib/java/org/springframework/spring-web
    contrib/java/org/springframework/spring-webmvc
    contrib/java/org/springframework/spring-aop

    contrib/java/org/springframework/security/spring-security-web
    contrib/java/org/springframework/security/spring-security-config

    contrib/java/com/fasterxml/jackson/core/jackson-databind

    contrib/java/org/apache/commons/commons-lang3
    contrib/java/org/apache/commons/commons-collections4
    contrib/java/commons-fileupload/commons-fileupload/1.3.2

    contrib/java/org/webjars/npm/babel-standalone/6.19.0
    contrib/java/org/webjars/npm/bootstrap/3.3.7
    contrib/java/org/webjars/npm/jquery/3.1.1
    contrib/java/org/webjars/npm/react/${react_version}
    contrib/java/org/webjars/npm/react-dom/${react_version}
    contrib/java/org/webjars/bower/es6-promise/4.0.5
    contrib/java/org/webjars/bower/fetch/2.0.3
    contrib/java/org/webjars/bower/moment/2.18.1
    contrib/java/org/webjars/bower/bootstrap-daterangepicker/2.1.25
    contrib/java/org/webjars/npm/graphiql/1.4.0
)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)

END()

