package ru.yandex.direct.useractionlog;

import ru.yandex.direct.mysql.MySQLColumnData;

public abstract class AbstractId {
    private final long id;

    public AbstractId(long id) {
        this.id = id;
    }

    public AbstractId(MySQLColumnData column) {
        String type = column.getSchema().getDataType();
        if ("int".equals(type) || "bigint".equals(type)) {
            id = Long.parseLong(column.getValueAsString());
        } else {
            throw new IllegalArgumentException("Expected column of type int or bigint, got " + type);
        }
    }

    public long toLong() {
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        return id == ((AbstractId) o).id;
    }

    @Override
    public int hashCode() {
        return (int) (id ^ (id >>> 32));
    }

    @Override
    public String toString() {
        return getClass().getName() + "{" + String.valueOf(id) + "}";
    }
}
