package ru.yandex.direct.useractionlog;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;

@ParametersAreNonnullByDefault
public class Methods {
    public static final String EXPORT_CAMP_XLS = "exportCampXLS";
    public static final String GET_IMPORTED_CAMP_XLS = "getImportedCampXls";
    public static final String DROP_IMPORTED_CAMP_XLS = "dropImportedCampXls";
    public static final String GET_IMPORTED_CAM_XLS_REPORT = "getImportedCampXlsReport";
    public static final String PRE_IMPORT_CAMP_XLS = "preImportCampXLS";
    public static final String IMPORT_CAMP_XLS = "importCampXLS";
    public static final String CONFIRM_SAVE_CAMP_XLS = "confirmSaveCampXLS";
    public static final String IMPORT_CAMP_TO_MEDIAPLAN_XLS = "importCampToMediaplanXLS";
    public static final String DROP_CAMP_XLS = "dropCampXLS";
    public static final String SHOW_EXPORTED_XLS_LIST = "showExportedXlsList";
    public static final String IMPORT_CAMP_SUCCESS = "importCampSuccess";

    public static final String SHOWCONDITIONS_UPDATE = "showconditions.update";

    public static final String GRID_EXECUTE_RECOMMENDATION = "grid.executeRecommendation";
    public static final String GRID_COMMUNICATION_ACTION = "grid.communicationAction";

    public static final String RECOMMENDATIONS_AUTO_APPLY_JOB = "recommendations.RecommendationsAutoApplyJob";
    public static final String RECOMMENDATIONS_APPLY_JOB = "recommendations.RecommendationsApplyJob";

    public static final String PPC_CAMP_QUEUE = "ppcCampQueue";

    // все методы, описанные в trunk/protected/DoCmdXls.pm.
    public static final Set<String> XLS_METHODS = ImmutableSet.of(
            EXPORT_CAMP_XLS,
            GET_IMPORTED_CAMP_XLS,
            DROP_IMPORTED_CAMP_XLS,
            GET_IMPORTED_CAM_XLS_REPORT,
            PRE_IMPORT_CAMP_XLS,
            IMPORT_CAMP_XLS,
            CONFIRM_SAVE_CAMP_XLS,
            IMPORT_CAMP_TO_MEDIAPLAN_XLS,
            DROP_CAMP_XLS,
            SHOW_EXPORTED_XLS_LIST,
            IMPORT_CAMP_SUCCESS);

    // В intapi не сохраняется информация о том, какой сервис и метод вызвал
    // данный intapi метод. Поэтому храним на своей стороне те методы, которыми
    // пользуется Web.
    // NB: Этот список нужно обновлять при добавлении новых методов в
    // trunk/protected/JavaIntapi
    public static final Set<String> WEB_INTAPI_METHODS = ImmutableSet.of(
            SHOWCONDITIONS_UPDATE);

    // Признаком применения рекомендации служит изменение через один из этих методов
    public static final Set<String> RECOMMENDATION_METHODS = ImmutableSet.of(
            GRID_EXECUTE_RECOMMENDATION,
            RECOMMENDATIONS_APPLY_JOB,
            RECOMMENDATIONS_AUTO_APPLY_JOB,
            GRID_COMMUNICATION_ACTION
            );

    private Methods() {
    }
}
