package ru.yandex.direct.useractionlog;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;

@ParametersAreNonnullByDefault
public class Services {
    public static final String WEB = "direct.web";
    public static final String PERL_WEB = "direct.perl.web";
    public static final String JOBS = "direct.jobs";
    public static final String INTAPI = "direct.intapi";
    public static final String SCRIPT = "direct.script";
    public static final String JSONRPC = "direct.jsonrpc";
    public static final String JSON_API = "direct.json-api";
    public static final String API5 = "direct.api5";
    public static final String SOAP_API = "direct.soap-api";

    public static final Set<String> API_SERVICES = ImmutableSet.of(API5, JSON_API, SOAP_API);

    private Services() {
    }
}
