package ru.yandex.direct.useractionlog.db;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.db.config.DbConfig;
import ru.yandex.direct.dbutil.wrapper.DatabaseWrapper;

/**
 * Базовая информация о хостах в ClickHouse-кластере и их взаимосвязях.
 */
@ParametersAreNonnullByDefault
public interface ClickHouseClusterInfo {
    /**
     * Набор DbConfig для всех хостов, которые есть в кластере
     */
    Collection<DbConfig> allUniqueDbConfigs();

    /**
     * @param tableName Название таблицы
     * @return Объекты, с помощью которых можно вести чтение или запись во все реплики всех шардов
     */
    Collection<DatabaseWrapper> getAllShardReplicas(String tableName);

    ClusterDbLabel getLabelForTable(String tableName);
}
