package ru.yandex.direct.useractionlog.db;

import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.wrapper.DatabaseWrapper;

/**
 * Сгруппированные вместе {@link ReadDictTable} и {@link WriteDictTable}.
 */
@ParametersAreNonnullByDefault
public class ReadWriteDictTable {
    public final ReadDictTable read;
    public final WriteDictTable write;

    public ReadWriteDictTable(ReadDictTable read, WriteDictTable write) {
        this.read = read;
        this.write = write;
    }

    public ReadWriteDictTable(Function<String, DatabaseWrapper> readDatabaseWrapperFn,
                              Function<String, DatabaseWrapper> writeDatabaseWrapperFn, String tableName) {
        this(new ReadDictTable(readDatabaseWrapperFn, tableName),
                new WriteDictTable(writeDatabaseWrapperFn, tableName));
    }
}
