package ru.yandex.direct.useractionlog.db;

import java.time.Duration;
import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.wrapper.DatabaseWrapper;

/**
 * Выбор шарда и реплики для каждой операции записи/чтения в определённую таблицу.
 */
@ParametersAreNonnullByDefault
public interface ShardReplicaChooser {
    /**
     * Выбрать некий хост для чтения таблицы.
     * В зависимости от таблицы может отличаться алгоритм выбора.
     *
     * @param tableName Название таблицы, из которой планируется читать
     */
    DatabaseWrapper getForReading(String tableName);

    /**
     * Выбрать некий хост для записи в таблицу.
     * В зависимости от таблицы может отличаться алгоритм выбора.
     *
     * @param tableName Название таблицы, в которую планируется писать
     */
    DatabaseWrapper getForWriting(String tableName);

    /**
     * Выбрать все хосты-лидеры для таблицы с движком Replicated*MergeTree.
     *
     * @param tableName Название таблицы
     * @param timeout   Максимальное время работы всего метода
     * @return {@link DatabaseWrapper} для каждого шарда
     */
    Collection<DatabaseWrapper> findEachShardLeader(String tableName, Duration timeout);
}
