package ru.yandex.direct.useractionlog.db;

import java.time.Duration;
import java.util.Collection;
import java.util.function.Supplier;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.wrapper.DatabaseWrapper;

@ParametersAreNonnullByDefault
public class ShardReplicaChooserLazyProxy implements ShardReplicaChooser {
    private final Supplier<ShardReplicaChooser> shardReplicaChooserSupplier;
    @Nullable
    private ShardReplicaChooser shardReplicaChooser;

    public ShardReplicaChooserLazyProxy(Supplier<ShardReplicaChooser> shardReplicaChooserSupplier) {
        this.shardReplicaChooserSupplier = shardReplicaChooserSupplier;
        this.shardReplicaChooser = null;
    }

    private ShardReplicaChooser getShardReplicaChooser() {
        if (shardReplicaChooser == null) {
            shardReplicaChooser = shardReplicaChooserSupplier.get();
        }
        return shardReplicaChooser;
    }

    @Override
    public DatabaseWrapper getForReading(String tableName) {
        return getShardReplicaChooser().getForReading(tableName);
    }

    @Override
    public DatabaseWrapper getForWriting(String tableName) {
        return getShardReplicaChooser().getForWriting(tableName);
    }

    @Override
    public Collection<DatabaseWrapper> findEachShardLeader(String tableName, Duration timeout) {
        return getShardReplicaChooser().findEachShardLeader(tableName, timeout);
    }
}
