package ru.yandex.direct.useractionlog.db;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.mysql.MySQLBinlogState;

/**
 * Всё, что может быть необходимо для чтения состояния пользовательских логов.
 */
@ParametersAreNonnullByDefault
public interface StateReader {
    /**
     * @param source Название источника, например "ppc:1"
     * @return Состояние для логов и состояние для словаря.
     */
    UserActionLogStates getActualStates(String source);

    /**
     * Актуальные состояния логов для всех источников.
     */
    Map<String, MySQLBinlogState> getAllActualLogStates();
}
