package ru.yandex.direct.useractionlog.db;

import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.wrapper.DatabaseWrapper;

/**
 * Сгруппированные вместе {@link StateReader} и {@link StateWriter}.
 */
@ParametersAreNonnullByDefault
public class StateReaderWriter {
    public final StateReader read;
    public final StateWriter write;

    public StateReaderWriter(StateReader read, StateWriter write) {
        this.read = read;
        this.write = write;
    }

    public StateReaderWriter(Function<String, DatabaseWrapper> readDatabaseWrapperFn,
                             Function<String, DatabaseWrapper> writeDatabaseWrapperFn, String tableName) {
        this(new ReadStateTable(readDatabaseWrapperFn, tableName),
                new WriteStateTable(writeDatabaseWrapperFn, tableName));
    }
}
