package ru.yandex.direct.useractionlog.db;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.mysql.MySQLBinlogState;

/**
 * Всё, что может быть необходимо для записи состояния пользовательских логов.
 */
@ParametersAreNonnullByDefault
public interface StateWriter {
    /**
     * Сохранить состояние таблицы логов.
     */
    void saveLogState(String source, MySQLBinlogState state);

    /**
     * Сохранить состояние таблицы словаря.
     */
    void saveDictState(String source, MySQLBinlogState state);

    /**
     * Сохранить одно и то же состояние как состояние таблицы логов и состояние таблицы словаря.
     */
    void saveBothStates(String source, MySQLBinlogState state);
}

