package ru.yandex.direct.useractionlog.db;

import javax.annotation.Nullable;

import ru.yandex.direct.mysql.MySQLBinlogState;

/**
 * Пара состояний: состояние таблицы логов и состояние таблицы словаря.
 * <p>
 * Состояние подразумевает собой набор gtid_set, которое было синхронизировано последним.
 * Чтение следует начать со следующего gtid_set.
 */
public class UserActionLogStates {
    public static final UserActionLogStates EMPTY = UserActionLogStates.builder().build();

    @Nullable
    private MySQLBinlogState dict;
    @Nullable
    private MySQLBinlogState log;

    private UserActionLogStates(Builder builder) {
        this.dict = builder.dict;
        this.log = builder.log;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public MySQLBinlogState getDict() {
        return dict;
    }

    @Nullable
    public MySQLBinlogState getLog() {
        return log;
    }

    public static class Builder {
        private MySQLBinlogState dict;
        private MySQLBinlogState log;

        private Builder() {
        }

        public Builder withDict(@Nullable MySQLBinlogState dictState) {
            this.dict = dictState;
            return this;
        }

        public Builder withLog(@Nullable MySQLBinlogState logState) {
            this.log = logState;
            return this;
        }

        public Builder fromOldStates(UserActionLogStates oldState) {
            return withDict(oldState.getDict()).withLog(oldState.getLog());
        }

        public UserActionLogStates build() {
            return new UserActionLogStates(this);
        }
    }
}
