package ru.yandex.direct.useractionlog.db;

import java.util.List;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.clickhouse.ClickHouseInsertable;
import ru.yandex.direct.dbutil.wrapper.DatabaseWrapper;
import ru.yandex.direct.useractionlog.schema.ActionLogRecord;
import ru.yandex.direct.useractionlog.schema.dict.DictSchema;

/**
 * Репозиторий с методами для записи в {@link DictSchema}.
 */
@ParametersAreNonnullByDefault
public class WriteActionLogTable implements ActionLogWriteRepository {
    private static final String INSERT_QUERY_TEMPLATE =
            SqlMappers.insertQueryTemplate(SqlMappers.ACTION_LOG_RECORD_MAPPERS);
    private static final ImmutableList<Function<ActionLogRecord, Object>> MAPPER_LIST =
            SqlMappers.fieldToSqlMapperList(SqlMappers.ACTION_LOG_RECORD_MAPPERS);

    private final Function<String, DatabaseWrapper> writeDatabaseWrapperFn;
    private final String tableName;

    /**
     * @param writeDatabaseWrapperFn Получение DatabaseWrapper по имени таблицы
     * @param tableName              Имя таблицы
     */
    public WriteActionLogTable(Function<String, DatabaseWrapper> writeDatabaseWrapperFn, String tableName) {
        this.writeDatabaseWrapperFn = writeDatabaseWrapperFn;
        this.tableName = tableName;
    }

    @SuppressWarnings("unchecked")
    private static Object sqlSerializer(Pair<ClickHouseInsertable, Function<ActionLogRecord, Object>> sqlMapping,
                                        ActionLogRecord actionLogRecord) {
        return sqlMapping.getKey().getType().toSqlObject(sqlMapping.getValue().apply(actionLogRecord));
    }

    @Override
    public void insert(List<ActionLogRecord> records) {
        SqlMappers.insertRecords(writeDatabaseWrapperFn.apply(tableName),
                tableName,
                INSERT_QUERY_TEMPLATE,
                MAPPER_LIST,
                records);
    }
}
