package ru.yandex.direct.useractionlog.db;

import java.util.Collection;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.clickhouse.ClickHouseInsertable;
import ru.yandex.direct.dbutil.wrapper.DatabaseWrapper;
import ru.yandex.direct.useractionlog.schema.dict.DictRecord;
import ru.yandex.direct.useractionlog.schema.dict.DictSchema;

/**
 * Репозиторий с методами для записи в {@link DictSchema}.
 */
@ParametersAreNonnullByDefault
public class WriteDictTable {
    private static final String INSERT_QUERY_TEMPLATE = SqlMappers.insertQueryTemplate(SqlMappers.DICT_MAPPERS);
    private static final ImmutableList<Function<DictRecord, Object>> MAPPER_LIST =
            SqlMappers.fieldToSqlMapperList(SqlMappers.DICT_MAPPERS);

    private final Function<String, DatabaseWrapper> writeDatabaseWrapperFn;
    private final String tableName;

    /**
     * @param writeDatabaseWrapperFn Получение DatabaseWrapper по имени таблицы
     * @param tableName              Имя таблицы
     */
    public WriteDictTable(Function<String, DatabaseWrapper> writeDatabaseWrapperFn, String tableName) {
        this.writeDatabaseWrapperFn = writeDatabaseWrapperFn;
        this.tableName = tableName;
    }

    @SuppressWarnings("unchecked")
    private static Object sqlSerializer(Pair<ClickHouseInsertable, Function<DictRecord, Object>> sqlMapping,
                                        DictRecord journalDictRecord) {
        return sqlMapping.getKey().getType().toSqlObject(sqlMapping.getValue().apply(journalDictRecord));
    }

    /**
     * Вставляет записи в таблицу одним INSERT-запросом
     */
    public void insert(Collection<DictRecord> records) {
        SqlMappers.insertRecords(writeDatabaseWrapperFn.apply(tableName),
                tableName,
                INSERT_QUERY_TEMPLATE,
                MAPPER_LIST,
                records);
    }
}
