package ru.yandex.direct.useractionlog.dict;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.jdbc.core.SingleColumnRowMapper;

import ru.yandex.direct.useractionlog.TableNames;
import ru.yandex.direct.useractionlog.db.ReadDictTable;
import ru.yandex.direct.useractionlog.db.ReadWriteDictTable;
import ru.yandex.direct.useractionlog.db.ShardReplicaChooser;
import ru.yandex.direct.useractionlog.db.WriteDictTable;

/**
 * DIRECT-75522
 * Заглушка для бесшовного обновления синхронизатора и web.
 * <p>
 * Временный словарь больше не нужен, но какое-то время web может ходить в базу со временным словарём, а потом он резко
 * переключится на базу без временного словаря. И до, и после этого момента приложение должно корректно работать.
 */
@Deprecated
@ParametersAreNonnullByDefault
public class ClickHouseJournalDictRepository implements DictRepository {
    private final DictRepository forwardDict;
    private final ShardReplicaChooser shardReplicaChooser;
    private final ClickHouseDictRepository deceptiveJournalDictRepository;

    public ClickHouseJournalDictRepository(DictRepository forwardDict, ShardReplicaChooser shardReplicaChooser) {
        this.forwardDict = forwardDict;
        this.shardReplicaChooser = shardReplicaChooser;
        this.deceptiveJournalDictRepository = new ClickHouseDictRepository(null,
                new ReadWriteDictTable(
                        new ReadDictTable(
                                ignored -> shardReplicaChooser.getForReading(TableNames.DICT_TABLE),
                                "journal_dict"),
                        new WriteDictTable(
                                ignored -> {
                                    throw new IllegalStateException("Should be never called");
                                },
                                "ignored")));
    }

    @Nonnull
    @Override
    public Map<DictRequest, Object> getData(Collection<DictRequest> dictRequests) {
        boolean tableNotExists = shardReplicaChooser.getForReading(TableNames.DICT_TABLE)
                .query("show tables like 'journal_dict'", new SingleColumnRowMapper<>())
                .isEmpty();
        if (tableNotExists) {
            return forwardDict.getData(dictRequests);
        }
        Map<DictRequest, Object> result = deceptiveJournalDictRepository.getData(dictRequests);
        Collection<DictRequest> restDictRequests = dictRequests.stream()
                .filter(r -> !result.containsKey(r))
                .collect(Collectors.toSet());
        if (!restDictRequests.isEmpty()) {
            result.putAll(forwardDict.getData(restDictRequests));
        }
        return result;
    }

    @Override
    public void addData(Map<DictRequest, Object> data) {
        throw new IllegalStateException("This deprecated class does not support adding data anymore");
    }
}
