package ru.yandex.direct.useractionlog.dict;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Попытка обратиться к словарным данным, которые не были запрошены. Свидетельствует о баге в коде какого-то наследника
 * {@code DictRequester}. Такие ошибки должны находиться на этапе тестирования.
 */
@ParametersAreNonnullByDefault
public class DictDataNotRequested extends RuntimeException {
    public DictDataNotRequested(DictDataCategory category, long id) {
        super(String.format("Was not requested: %s %d", category, id));
    }
}
