package ru.yandex.direct.useractionlog.dict;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.useractionlog.db.ReadDictTable;
import ru.yandex.direct.useractionlog.db.ReadWriteDictTable;
import ru.yandex.direct.useractionlog.db.ShardReplicaChooser;
import ru.yandex.direct.useractionlog.db.WriteDictTable;
import ru.yandex.direct.utils.FunctionalUtils;

/**
 * Цепочки классов для доступа к словарям.
 */
@ParametersAreNonnullByDefault
public class DictDefaults {
    private DictDefaults() {
    }

    /**
     * Словарь для синхронизатора.
     */
    public static DictRepository makeReadWriteDictRepository(String source, ReadWriteDictTable dictTable) {
        return new CacheDictRepository(makeDictRepository(source, dictTable));
    }

    @Nonnull
    private static DictRepository makeDictRepository(@Nullable String source, ReadWriteDictTable dictTable) {
        return new ClickHouseDictRepository(source, dictTable);
    }

    /**
     * Словарь для читалки.
     */
    public static DictRepository makeReadOnlyDictRepository(ReadDictTable dictTable) {
        ReadWriteDictTable readWriteDictTable = new ReadWriteDictTable(
                dictTable,
                new WriteDictTable(FunctionalUtils.unsupportedFunction(), ""));
        return new ReadOnlyDictRepository(makeDictRepository(null, readWriteDictTable));
    }

    @Deprecated
    public static DictRepository makeReadOnlyJournalDictRepository(ReadDictTable dictTable, ShardReplicaChooser shardReplicaChooser) {
        return new ClickHouseJournalDictRepository(makeReadOnlyDictRepository(dictTable), shardReplicaChooser);
    }
}
