package ru.yandex.direct.useractionlog.dict;

import java.util.Collection;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Интерфейс для бэкендов к словарным данным, реализующим их получение и запись.
 */
@ParametersAreNonnullByDefault
public interface DictRepository {
    /**
     * Получить данные для набора {@link DictRequest}. Если какие-то данные
     * невозможно получить, они просто будут отсутствовать в результирующей коллекции.
     *
     * @param dictRequests Коллекция запросов
     * @return Коллекция ответов
     */
    @Nonnull
    Map<DictRequest, Object> getData(Collection<DictRequest> dictRequests);

    /**
     * Добавить новые словарные данные. Если они уже известны, то ничего не должно произойти.
     *
     * @param data Коллекция новых словарных данных. <b>Внимание:</b> владение объектом не передаётся. Вызывающая
     *             сторона может модифицировать data после вызова этого метода. Если планируется отложенная запись
     *             данных, то реализующий интерфейс класс должен копировать данные из data.
     */
    void addData(Map<DictRequest, Object> data);
}
