package ru.yandex.direct.useractionlog.dict;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Запрос на получение одного значения из словаря.
 */
@ParametersAreNonnullByDefault
public class DictRequest {
    private final DictDataCategory category;
    private final long id;

    /**
     * Создать запрос на получение одного значения из словаря.
     *
     * @param category Категория словарного значения.
     * @param id       Идентификатор значения, применимый к выбранной категории.
     */
    public DictRequest(DictDataCategory category, long id) {
        this.category = category;
        this.id = id;
    }

    public DictDataCategory getCategory() {
        return category;
    }

    public long getId() {
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DictRequest)) {
            return false;
        }
        DictRequest that = (DictRequest) o;
        return id == that.id &&
                category == that.category;
    }

    @Override
    public int hashCode() {
        return Objects.hash(category, id);
    }

    @Override
    public String toString() {
        return "DictRequest{" +
                "category=" + category +
                ", id=" + id +
                '}';
    }
}
