package ru.yandex.direct.useractionlog.dict;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.useractionlog.schema.ObjectPath;

/**
 * Класс для составления списка новых словарных данных. Передаётся в генератор пользовательских логов чтобы
 * абстрагировать его от знания внутренней кухни словарей.
 */
@ParametersAreNonnullByDefault
public class FreshDictValuesFiller {
    private final Map<DictRequest, Object> newData;

    /**
     * @param newData Буферный объект, в который будут складываться все новые словарные данные.
     */
    public FreshDictValuesFiller(Map<DictRequest, Object> newData) {
        this.newData = newData;
    }

    public void add(DictRequest dictRequest, Object value) {
        newData.put(dictRequest, value);
    }

    /**
     * Записать в словарь значение для указанных категории и идентификатора.
     */
    public void add(DictDataCategory category, long id, Object value) {
        add(new DictRequest(category, id), value);
    }

    /**
     * Добавить в словарь новый {@link ObjectPath.CampaignPath}
     *
     * @param path Путь к кампании
     */
    public void addCampaignPath(ObjectPath.CampaignPath path) {
        add(DictDataCategory.CAMPAIGN_PATH, path.getId().toLong(), path);
    }

    /**
     * Добавить в словарь новое название кампании
     *
     * @param campaignId Идентификатор кампании
     * @param name       Новое название
     */
    public void addCampaignName(long campaignId, String name) {
        add(DictDataCategory.CAMPAIGN_NAME, campaignId, name);
    }

    public void addAdGroupPath(ObjectPath.AdGroupPath path) {
        add(DictDataCategory.ADGROUP_PATH, path.getId().toLong(), path);
    }

    /**
     * Добавить в словарь новое название группы
     *
     * @param adGroupId Идентификатор группы
     * @param name      Новое название
     */
    public void addAdGroupName(long adGroupId, String name) {
        add(DictDataCategory.ADGROUP_NAME, adGroupId, name);
    }

    public void addAdPath(ObjectPath.AdPath path) {
        add(DictDataCategory.AD_PATH, path.getId().toLong(), path);
    }

    public void addAdTitle(long adId, String title) {
        add(DictDataCategory.AD_TITLE, adId, title);
    }

    public void addRetargetingConditionName(long retargetingConditionId, String retargetingConditionName) {
        add(DictDataCategory.RETARGETING_CONDITION_NAME, retargetingConditionId, retargetingConditionName);
    }
}
