package ru.yandex.direct.useractionlog.dict;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

/**
 * Словарь, который хранит все данные в оперативной памяти. Удобен для юнит-тестов.
 */
@ParametersAreNonnullByDefault
public class MemoryDictRepository implements DictRepository {
    public final Map<DictRequest, Object> repositoryMap = new HashMap<>();

    public final List<DictRequest> requestLog = new ArrayList<>();

    @Nonnull
    @Override
    public Map<DictRequest, Object> getData(Collection<DictRequest> dictRequests) {
        requestLog.addAll(dictRequests);
        return new HashMap<>(Maps.filterKeys(repositoryMap, dictRequests::contains));
    }

    @Override
    public void addData(Map<DictRequest, Object> data) {
        repositoryMap.putAll(data);
    }

    public MemoryDictRepository addData(DictDataCategory category, long id, Object value) {
        addData(ImmutableMap.of(new DictRequest(category, id), value));
        return this;
    }
}
