package ru.yandex.direct.useractionlog.dict;

import java.util.Collection;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;

/**
 * Прокси-словарь с защитой от записи.
 */
@ParametersAreNonnullByDefault
@ThreadSafe
public class ReadOnlyDictRepository implements DictRepository {
    private final DictRepository forwardDict;

    public ReadOnlyDictRepository(DictRepository forwardDict) {
        this.forwardDict = forwardDict;
    }

    @Nonnull
    @Override
    public Map<DictRequest, Object> getData(Collection<DictRequest> dictRequests) {
        return forwardDict.getData(dictRequests);
    }

    @Override
    public void addData(Map<DictRequest, Object> data) {
        throw new UnsupportedOperationException("This is read-only dictionary");
    }
}
