package ru.yandex.direct.useractionlog.model;

import java.util.LinkedHashMap;

import javax.annotation.Nonnull;

import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.binlogclickhouse.schema.FieldValueList;
import ru.yandex.direct.useractionlog.AdGroupId;
import ru.yandex.direct.useractionlog.CampaignId;

import static ru.yandex.direct.dbschema.ppc.Ppc.PPC;

public class AdGroupRowModel extends RowModel {
    private static final String VERSION = "0";

    private static final String CAMPAIGN_ID_NAME = PPC.PHRASES.CID.getName();
    private static final String AD_GROUP_ID_NAME = PPC.PHRASES.PID.getName();

    public AdGroupRowModel(LinkedHashMap<String, String> map) {
        super(map);
    }

    public AdGroupRowModel() {
    }

    public AdGroupRowModel(FieldValueList list) {
        super(list);

    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    public CampaignId getCampaignId() {
        String value = map.get(CAMPAIGN_ID_NAME);
        if (value == null) {
            return null;
        }
        return new CampaignId(Long.parseLong(value));
    }

    public AdGroupId getAdGroupId() {
        String value = map.get(AD_GROUP_ID_NAME);
        if (value == null) {
            return null;
        }
        return new AdGroupId(Long.parseLong(value));
    }

    @Override
    @Nonnull
    Pair<CampaignId, AdGroupId> getObjectPathParts() {
        CampaignId campaignId = getCampaignId();
        AdGroupId adGroupId = getAdGroupId();
        return Pair.of(campaignId, adGroupId);
    }
}
