package ru.yandex.direct.useractionlog.model;

import java.time.LocalDateTime;
import java.util.Objects;

import ru.yandex.direct.useractionlog.schema.ObjectPath;

/**
 * Запись с информацией о событии автоматического изменения настроек кампании
 */
public class AutoUpdatedSettingsEvent {

    private AutoChangeableSettings settings;

    private Long targetObjectId;

    private ObjectPath path;

    private String item;

    private String subitem;

    private String oldValue;

    private String newValue;

    private LocalDateTime lastAutoUpdateTime;

    private boolean isAutoApplyEnabled;

    public AutoChangeableSettings getSettings() {
        return settings;
    }

    public void setSettings(AutoChangeableSettings settings) {
        this.settings = settings;
    }

    public AutoUpdatedSettingsEvent withSettings(AutoChangeableSettings settings) {
        setSettings(settings);
        return this;
    }

    /**
     * Идентификатор объекта (кампании, группы и т.д.) */
    public Long getTargetObjectId() {
        return targetObjectId;
    }

    public void setTargetObjectId(Long targetObjectId) {
        this.targetObjectId = targetObjectId;
    }

    public AutoUpdatedSettingsEvent withTargetObjectId(Long targetObjectId) {
        setTargetObjectId(targetObjectId);
        return this;
    }

    /**
     * Путь до объекта в пользовательских логах */
    public ObjectPath getPath() {
        return path;
    }

    public void setPath(ObjectPath path) {
        this.path = path;
    }

    public AutoUpdatedSettingsEvent withPath(ObjectPath path) {
        setPath(path);
        return this;
    }

    /**
     * Поле объекта (стратегия, настройки дневного бюджета и т.п.) для поиска в логах */
    public String getItem() {
        return item;
    }

    public void setItem(String item) {
        this.item = item;
    }

    public AutoUpdatedSettingsEvent withItem(String item) {
        setItem(item);
        return this;
    }

    /**
     * Параметр внутри поля объекта (недельный бюджет внутри стратегии) */
    public String getSubitem() {
        return subitem;
    }

    public void setSubitem(String subitem) {
        this.subitem = subitem;
    }

    public AutoUpdatedSettingsEvent withSubitem(String subitem) {
        setSubitem(subitem);
        return this;
    }

    /**
     * Старое значение настройки (до последнего автоприменения рекомендации) */
    public String getOldValue() {
        return oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public AutoUpdatedSettingsEvent withOldValue(String oldValue) {
        setOldValue(oldValue);
        return this;
    }

    /**
     * Новое значение настройки (после последнего автоприменения рекомендации) */
    public String getNewValue() {
        return newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public AutoUpdatedSettingsEvent withNewValue(String newValue) {
        setNewValue(newValue);
        return this;
    }

    /**
     * Дата/время последнего автоприменения рекомендации */
    public LocalDateTime getLastAutoUpdateTime() {
        return lastAutoUpdateTime;
    }

    public void setLastAutoUpdateTime(LocalDateTime lastAutoUpdateTime) {
        this.lastAutoUpdateTime = lastAutoUpdateTime;
    }

    public AutoUpdatedSettingsEvent withLastAutoUpdateTime(LocalDateTime lastAutoUpdateTime) {
        setLastAutoUpdateTime(lastAutoUpdateTime);
        return this;
    }

    /**
     * @return включена ли в даанный момент настройка автоприменения рекомендаций влияющая на конкретно эту настройку
     */
    public boolean isAutoApplyEnabled() {
        return isAutoApplyEnabled;
    }

    public void setAutoApplyEnabled(boolean autoApplyEnabled) {
        isAutoApplyEnabled = autoApplyEnabled;
    }

    public AutoUpdatedSettingsEvent withAutoApplyEnabled(boolean isAutoApplyEnabled) {
        setAutoApplyEnabled(isAutoApplyEnabled);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AutoUpdatedSettingsEvent that = (AutoUpdatedSettingsEvent) o;
        return isAutoApplyEnabled == that.isAutoApplyEnabled && Objects.equals(settings, that.settings) && Objects.equals(targetObjectId, that.targetObjectId) && Objects.equals(path, that.path) && Objects.equals(item, that.item) && Objects.equals(subitem, that.subitem) && Objects.equals(oldValue, that.oldValue) && Objects.equals(newValue, that.newValue) && Objects.equals(lastAutoUpdateTime, that.lastAutoUpdateTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(settings, targetObjectId, path, item, subitem, oldValue, newValue, lastAutoUpdateTime, isAutoApplyEnabled);
    }

    @Override
    public String toString() {
        return "AutoUpdatedSettingsEvent{" +
                "settings=" + settings +
                ", targetObjectId=" + targetObjectId +
                ", path=" + path +
                ", item='" + item + '\'' +
                ", subitem='" + subitem + '\'' +
                ", oldValue='" + oldValue + '\'' +
                ", newValue='" + newValue + '\'' +
                ", lastAutoUpdateTime=" + lastAutoUpdateTime +
                ", isAutoApplyEnabled=" + isAutoApplyEnabled +
                '}';
    }
}
