package ru.yandex.direct.useractionlog.model

import ru.yandex.direct.binlogclickhouse.schema.FieldValueList
import ru.yandex.direct.dbschema.ppc.Ppc
import ru.yandex.direct.useractionlog.AdGroupId
import ru.yandex.direct.useractionlog.CampaignId

class BidBaseRowModel : RowModel {

    constructor() : super()
    constructor(list: FieldValueList) : super(list)
    constructor(map: LinkedHashMap<String, String>) : super(map)

    companion object {
        private const val VERSION = "0"

        private val AD_GROUP_ID_NAME = Ppc.PPC.PHRASES.PID.name
        private val CAMPAIGN_ID_NAME = Ppc.PPC.CAMPAIGNS.CID.name
    }

    override fun getObjectPathParts(): Any = Pair(
        map[CAMPAIGN_ID_NAME]?.let { CampaignId(it.toLong()) },
        map[AD_GROUP_ID_NAME]?.let { AdGroupId(it.toLong()) },
    )

    override fun getVersion(): String = VERSION
}
