package ru.yandex.direct.useractionlog.model;

import java.util.LinkedHashMap;
import java.util.Optional;

import javax.annotation.Nonnull;

import ru.yandex.direct.binlogclickhouse.schema.FieldValueList;
import ru.yandex.direct.useractionlog.CampaignId;

import static ru.yandex.direct.dbschema.ppc.Ppc.PPC;

public class CampOptionsRowModel extends RowModel {
    private static final String VERSION = "0";

    private static final String CAMPAIGN_ID_NAME = PPC.CAMP_OPTIONS.CID.getName();

    public CampOptionsRowModel() {
    }

    public CampOptionsRowModel(LinkedHashMap<String, String> map) {
        super(map);
    }

    public CampOptionsRowModel(FieldValueList list) {
        super(list);
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    public CampaignId getCampaignId() {
        String value = map.get(CAMPAIGN_ID_NAME);
        if (value == null) {
            return null;
        }
        return new CampaignId(Long.parseLong(value));
    }

    @Override
    @Nonnull
    Optional<CampaignId> getObjectPathParts() {
        return Optional.ofNullable(getCampaignId());
    }
}
