package ru.yandex.direct.useractionlog.model;

import java.util.LinkedHashMap;
import java.util.Optional;

import javax.annotation.Nonnull;

import ru.yandex.direct.binlogclickhouse.schema.FieldValueList;
import ru.yandex.direct.useractionlog.ClientId;

import static ru.yandex.direct.dbschema.ppc.Ppc.PPC;

public class ClientOptionsRowModel extends RowModel {
    private static final String VERSION = "0";

    private static final String CLIENT_ID_NAME = PPC.CLIENTS_OPTIONS.CLIENT_ID.getName();

    public ClientOptionsRowModel() {
    }

    public ClientOptionsRowModel(LinkedHashMap<String, String> map) {
        super(map);
    }

    public ClientOptionsRowModel(FieldValueList list) {
        super(list);
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    public ClientId getClientId() {
        String value = map.get(CLIENT_ID_NAME);
        if (value == null) {
            return null;
        }
        return new ClientId(Long.parseLong(value));
    }

    @Override
    @Nonnull
    Optional<ClientId> getObjectPathParts() {
        return Optional.ofNullable(getClientId());
    }
}
