package ru.yandex.direct.useractionlog.model;

import java.time.LocalDateTime;
import java.util.Objects;

import ru.yandex.direct.useractionlog.schema.ObjectPath;

/**
 * Информация о включении/выключении настройки автоприменения рекомендаций
 */
public class RecommendationsManagementHistory {

    private final String recommendationOptionName;

    private final ObjectPath path;

    private final LocalDateTime lastUpdateDateTime;

    private final String lastUpdateValue;

    public RecommendationsManagementHistory(String recommendationOptionName, ObjectPath path,
                                            LocalDateTime lastUpdateDateTime, String lastUpdateValue) {
        this.recommendationOptionName = recommendationOptionName;
        this.path = path;
        this.lastUpdateDateTime = lastUpdateDateTime;
        this.lastUpdateValue = lastUpdateValue;
    }

    public String getRecommendationOptionName() {
        return recommendationOptionName;
    }

    public ObjectPath getPath() {
        return path;
    }

    public LocalDateTime getLastUpdateDateTime() {
        return lastUpdateDateTime;
    }

    public boolean isEnabled(){
        return "1".equals(lastUpdateValue); }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RecommendationsManagementHistory that = (RecommendationsManagementHistory) o;
        return Objects.equals(recommendationOptionName, that.recommendationOptionName) && Objects.equals(path,
                that.path) && Objects.equals(lastUpdateDateTime, that.lastUpdateDateTime) && Objects.equals(lastUpdateValue, that.lastUpdateValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(recommendationOptionName, path, lastUpdateDateTime, lastUpdateValue);
    }

    @Override
    public String toString() {
        return "RecommendationsManagementHistory{" +
                "recommendationOptionName='" + recommendationOptionName + '\'' +
                ", path=" + path +
                ", lastUpdateDateTime=" + lastUpdateDateTime +
                ", lastUpdateValue='" + lastUpdateValue + '\'' +
                '}';
    }
}
