package ru.yandex.direct.useractionlog.model;

import java.util.LinkedHashMap;

import javax.annotation.Nonnull;

import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.binlogclickhouse.schema.FieldValueList;
import ru.yandex.direct.useractionlog.ClientId;
import ru.yandex.direct.useractionlog.schema.RetargetingConditionId;

import static ru.yandex.direct.dbschema.ppc.Ppc.PPC;

public class RetargetingConditionsRowModel extends RowModel {
    private static final String VERSION = "0";

    private static final String CLIENT_ID_NAME = PPC.RETARGETING_CONDITIONS.CLIENT_ID.getName();
    private static final String RETARGETING_CONDITION_ID_NAME = PPC.RETARGETING_CONDITIONS.RET_COND_ID.getName();

    public RetargetingConditionsRowModel() {
    }

    public RetargetingConditionsRowModel(LinkedHashMap<String, String> map) {
        super(map);
    }

    public RetargetingConditionsRowModel(FieldValueList list) {
        super(list);
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    public ClientId getClientId() {
        String value = map.get(CLIENT_ID_NAME);
        if (value == null) {
            return null;
        }
        return new ClientId(Long.parseLong(value));
    }

    public RetargetingConditionId getRetargetingConditionId() {
        String value = map.get(RETARGETING_CONDITION_ID_NAME);
        if (value == null) {
            return null;
        }
        return new RetargetingConditionId(Long.parseLong(value));
    }

    @Override
    @Nonnull
    Pair<ClientId, RetargetingConditionId> getObjectPathParts() {
        ClientId clientId = getClientId();
        RetargetingConditionId retargetingConditionId = getRetargetingConditionId();
        return Pair.of(clientId, retargetingConditionId);
    }
}
