package ru.yandex.direct.useractionlog.model;

import java.text.MessageFormat;

import ru.yandex.direct.binlog.reader.EnrichedDeleteRow;
import ru.yandex.direct.binlog.reader.EnrichedInsertRow;
import ru.yandex.direct.binlog.reader.EnrichedRow;
import ru.yandex.direct.binlog.reader.EnrichedUpdateRow;
import ru.yandex.direct.binlogclickhouse.schema.FieldValueList;

public class RowModelPair<Model extends RowModel> {
    public final Model before;
    public final Model after;

    public RowModelPair(Model before, Model after) {
        this.before = before;
        this.after = after;
    }

    public boolean isEmpty() {
        return before.isEmpty() && after.isEmpty();
    }

    public void validate() {
        before.validate();
        after.validate();
        if (!(before.isEmpty() || after.isEmpty() || before.isValidObjectPathChange(after))) {
            throw new IllegalStateException(MessageFormat.format(
                    "Invalid changing object path parts from ({0}) to ({1})",
                    before.getObjectPathParts(),
                    after.getObjectPathParts()));
        }
    }

    public static RowModelPair fromRow(EnrichedRow row) {
        FieldValueList before;
        FieldValueList after;
        if (row instanceof EnrichedInsertRow) {
            before = FieldValueList.empty();
            after = FieldValueList.fromColumnDataList(((EnrichedInsertRow) row).getFields());
        } else if (row instanceof EnrichedUpdateRow) {
            EnrichedUpdateRow updateRow = (EnrichedUpdateRow) row;
            before = FieldValueList.fromColumnDataList(updateRow.getFields().getBefore());
            after = FieldValueList.fromColumnDataList(updateRow.getFields().getAfter());
        } else if (row instanceof EnrichedDeleteRow) {
            before = FieldValueList.fromColumnDataList(((EnrichedDeleteRow) row).getFields());
            after = FieldValueList.empty();
        } else {
            throw new UnsupportedOperationException(row.getClass().toString());
        }
        return makeRowModelPair(row.getTableName(), before, after);
    }

    public static RowModelPair makeRowModelPair(String tableName, FieldValueList before, FieldValueList after) {
        return new RowModelPair<>(RowModel.makeRowModel(tableName, before), RowModel.makeRowModel(tableName, after));
    }
}
