package ru.yandex.direct.useractionlog.schema;

import ru.yandex.direct.clickhouse.ClickHouseType;
import ru.yandex.direct.clickhouse.InsertRecord;

public class ObjectPathClickHouseType extends ClickHouseType<ObjectPath> {
    public ObjectPathClickHouseType() {
        super("String");
    }

    @Override
    public ObjectPath fromClickHouseString(String stringValue) {
        return ObjectPath.fromPathString(stringValue);
    }

    @Override
    public ObjectPath fromJavaSqlResult(Object value) {
        return ObjectPath.fromPathString((String) value);
    }

    @Override
    public void setNextInRecord(InsertRecord record, ObjectPath value) {
        record.setNext((String) toSqlObject(value));
    }

    @Override
    public Object toSqlObject(ObjectPath value) {
        return value.toPathString();
    }
}
