package ru.yandex.direct.useractionlog.schema;

import java.time.LocalDate;
import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Класс для объекта-записи в {@link PpclogApiSchema}
 */
@ParametersAreNonnullByDefault
public class PpclogApiRecord {
    private final LocalDate date;
    private final LocalDateTime dateTime;
    private final Long reqid;
    private final String applicationId;

    public PpclogApiRecord(LocalDate date, LocalDateTime dateTime, Long reqid, String applicationId) {
        this.date = date;
        this.dateTime = dateTime;
        this.reqid = reqid;
        this.applicationId = applicationId;
    }

    public LocalDate getDate() {
        return date;
    }

    public Long getReqid() {
        return reqid;
    }

    public String getApplicationId() {
        return applicationId;
    }

    public LocalDateTime getDateTime() {
        return dateTime;
    }

    @Override
    public String toString() {
        return "PpclogApiRecord{" +
                "date=" + date +
                ", dateTime=" + dateTime +
                ", reqid=" + reqid +
                ", applicationId='" + applicationId + '\'' +
                '}';
    }
}
