package ru.yandex.direct.useractionlog.schema;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.core.type.TypeReference;

import ru.yandex.direct.clickhouse.SimpleField;
import ru.yandex.direct.clickhouse.TableSchema;
import ru.yandex.direct.clickhouse.types.ArrayClickHouseType;
import ru.yandex.direct.clickhouse.types.DateClickHouseType;
import ru.yandex.direct.clickhouse.types.DateTimeClickHouseType;
import ru.yandex.direct.clickhouse.types.Float32ClickHouseType;
import ru.yandex.direct.clickhouse.types.IntegerClickHouseType;
import ru.yandex.direct.clickhouse.types.LongClickHouseType;
import ru.yandex.direct.clickhouse.types.StringClickHouseType;

@ParametersAreNonnullByDefault
public class PpclogApiSchema extends TableSchema {
    public static final SimpleField<LocalDate> LOG_DATE = new SimpleField<>("log_date", new DateClickHouseType());
    public static final SimpleField<LocalDateTime> LOG_TIME = new SimpleField<>("log_time", new DateTimeClickHouseType());
    public static final SimpleField<List<Long>> CID = new SimpleField<>("cid",
            new ArrayClickHouseType<>(new LongClickHouseType("Int64"), new TypeReference<List<Long>>() {
            }));
    public static final SimpleField<List<Long>> BID = new SimpleField<>("bid",
            new ArrayClickHouseType<>(new LongClickHouseType("Int64"), new TypeReference<List<Long>>() {
            }));
    public static final SimpleField<String> IP = new SimpleField<>("ip", new StringClickHouseType());
    public static final SimpleField<String> CMD = new SimpleField<>("cmd", new StringClickHouseType());
    public static final SimpleField<Float> RUNTIME = new SimpleField<>("runtime", new Float32ClickHouseType());
    public static final SimpleField<String> PARAM = new SimpleField<>("param", new StringClickHouseType());
    public static final SimpleField<Long> HTTP_STATUS = new SimpleField<>("http_status", new LongClickHouseType("Int64"));
    public static final SimpleField<List<Long>> CLUID = new SimpleField<>("cluid",
            new ArrayClickHouseType<>(new LongClickHouseType("Int64"), new TypeReference<List<Long>>() {
            }));
    public static final SimpleField<Long> REQID = new SimpleField<>("reqid", new LongClickHouseType("Int64"));
    public static final SimpleField<Long> UID = new SimpleField<>("uid", new LongClickHouseType("Int64"));
    public static final SimpleField<String> HOST = new SimpleField<>("host", new StringClickHouseType());
    public static final SimpleField<Long> PROC_ID = new SimpleField<>("proc_id", new LongClickHouseType("Int64"));
    public static final SimpleField<Float> FULLTIME = new SimpleField<>("fulltime", new Float32ClickHouseType());
    public static final SimpleField<String> ERROR_DETAILS = new SimpleField<>("error_details", new StringClickHouseType());
    public static final SimpleField<Long> UNITS = new SimpleField<>("units", new LongClickHouseType("Int64"));
    public static final SimpleField<String> UNITS_STATS = new SimpleField<>("units_stats", new StringClickHouseType());
    public static final SimpleField<Integer> API_VERSION = new SimpleField<>("api_version", new IntegerClickHouseType("UInt8"));
    public static final SimpleField<String> INTERFACE = new SimpleField<>("interface", new StringClickHouseType());
    public static final SimpleField<String> APPLICATION_ID = new SimpleField<>("application_id", new StringClickHouseType());
    public static final SimpleField<String> RESPONSE = new SimpleField<>("response", new StringClickHouseType());
    public static final SimpleField<List<Long>> RESPONSE_IDS = new SimpleField<>("response_ids",
            new ArrayClickHouseType<>(new LongClickHouseType("Int64"), new TypeReference<List<Long>>() {
            }));
    public static final SimpleField<String> SOURCE = new SimpleField<>("source", new StringClickHouseType());
    public static final SimpleField<Long> UNITS_SPENDING_USER_CLIENT_ID = new SimpleField<>(
            "units_spending_user_client_id", new LongClickHouseType("Int64"));
    public static final SimpleField<Long> ERROR_OBJECT_COUNT = new SimpleField<>(
            "error_object_count", new LongClickHouseType("Int64"));
    public static final SimpleField<Long> WARNING_OBJECT_COUNT = new SimpleField<>(
            "warning_object_count", new LongClickHouseType("Int64"));

    public static final SimpleField[] INDEX_COLUMNS = new SimpleField[]{
            LOG_DATE, LOG_TIME
    };

    public PpclogApiSchema(String dbName, String tableName) {
        super(
                dbName,
                tableName,
                Arrays.asList(
                        LOG_DATE,
                        LOG_TIME,
                        CID,
                        BID,
                        IP,
                        CMD,
                        RUNTIME,
                        PARAM,
                        HTTP_STATUS,
                        CLUID,
                        REQID,
                        UID,
                        HOST,
                        PROC_ID,
                        FULLTIME,
                        ERROR_DETAILS,
                        UNITS,
                        UNITS_STATS,
                        API_VERSION,
                        INTERFACE,
                        APPLICATION_ID,
                        RESPONSE,
                        RESPONSE_IDS,
                        SOURCE,
                        UNITS_SPENDING_USER_CLIENT_ID,
                        ERROR_OBJECT_COUNT,
                        WARNING_OBJECT_COUNT),
                "MergeTree",
                Arrays.asList(
                        LOG_DATE.getName(),
                        "(" + Stream.of(INDEX_COLUMNS)
                                .map(SimpleField::getName)
                                .collect(Collectors.joining(", "))
                                + ")",
                        "8192"));
    }
}
