package ru.yandex.direct.useractionlog.schema;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableList;

import ru.yandex.direct.clickhouse.SimpleField;
import ru.yandex.direct.clickhouse.TableSchema;
import ru.yandex.direct.clickhouse.types.DateClickHouseType;
import ru.yandex.direct.clickhouse.types.DateTimeClickHouseType;
import ru.yandex.direct.clickhouse.types.EnumClickHouseType;
import ru.yandex.direct.clickhouse.types.StringClickHouseType;
import ru.yandex.direct.utils.FunctionalUtils;

/**
 * ClickHouse-таблица для хранения состояния пользовательских логов и словаря.
 */
@ParametersAreNonnullByDefault
public class StateSchema extends TableSchema {
    public static final SimpleField<LocalDate> DATE =
            new SimpleField<>("date", new DateClickHouseType());
    public static final SimpleField<LocalDateTime> DATETIME =
            new SimpleField<>("datetime", new DateTimeClickHouseType());
    public static final SimpleField<String> SOURCE =
            new SimpleField<>("source", new StringClickHouseType());
    public static final SimpleField<String> STATE =
            new SimpleField<>("state", new StringClickHouseType());
    public static final SimpleField<UserActionLogStateType> TYPE =
            new SimpleField<>("type", new EnumClickHouseType<>("Enum8", UserActionLogStateType.class));

    public static final List<SimpleField<?>> INDEX_COLUMNS = ImmutableList.of(SOURCE, TYPE, DATE);

    public StateSchema(String dbName, String tableName) {
        super(
                dbName,
                tableName,
                Arrays.asList(
                        SOURCE,
                        TYPE,
                        DATE,
                        DATETIME,
                        STATE),
                "ReplacingMergeTree",
                Arrays.asList(
                        DATE.getName(),
                        String.format("(%s)", String.join(", ",
                                FunctionalUtils.mapList(INDEX_COLUMNS, SimpleField::getName))),
                        "1024",
                        DATETIME.getName()));
    }
}
