package ru.yandex.direct.useractionlog.writer.generator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlog.reader.EnrichedInsertRow;
import ru.yandex.direct.binlog.reader.EnrichedRow;
import ru.yandex.direct.binlog.reader.MySQLSimpleRowIndexed;
import ru.yandex.direct.useractionlog.AdGroupId;
import ru.yandex.direct.useractionlog.dict.DictDataCategory;
import ru.yandex.direct.useractionlog.dict.DictRequestsFiller;
import ru.yandex.direct.useractionlog.dict.DictResponsesAccessor;
import ru.yandex.direct.useractionlog.dict.FreshDictValuesFiller;
import ru.yandex.direct.useractionlog.schema.ObjectPath;

import static ru.yandex.direct.dbschema.ppc.tables.Phrases.PHRASES;

/**
 * Специализируется на таблицах, в которых первичный ключ - идентификатор группы. Например, ppc.phrases.
 */
@ParametersAreNonnullByDefault
class AdGroupPathStrategy implements ObjectPathStrategy {
    @Override
    public Collection<String> objectPathColumns() {
        return Arrays.asList(PHRASES.PID.getName(), PHRASES.CID.getName());
    }

    @Override
    public void fillDictRequests(EnrichedRow row, DictRequestsFiller dictRequests) {
        dictRequests.requireCampaignPath(Util.fieldAsLong(Util.dataForGettingId(row), PHRASES.CID));
    }

    @Override
    public ObjectPath extract(EnrichedRow row, DictResponsesAccessor dictResponsesAccessor) {
        MySQLSimpleRowIndexed fields = Util.dataForGettingId(row);
        return new ObjectPath.AdGroupPath(
                dictResponsesAccessor.getCampaignPath(Util.fieldAsLong(fields, PHRASES.CID)),
                new AdGroupId(Util.fieldAsLong(fields, PHRASES.PID)));
    }

    @Override
    public void fillFreshDictValues(EnrichedRow row, DictResponsesAccessor dictData,
                                    FreshDictValuesFiller freshDictValues) {
        if (row instanceof EnrichedInsertRow) {
            freshDictValues.addAdGroupPath((ObjectPath.AdGroupPath) extract(row, dictData));
        }
    }

    @Override
    public Collection<DictDataCategory> provides() {
        return Collections.singleton(DictDataCategory.ADGROUP_PATH);
    }
}
