package ru.yandex.direct.useractionlog.writer.generator;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.useractionlog.dict.DictDataCategory;
import ru.yandex.direct.useractionlog.schema.RecordSource;

import static ru.yandex.direct.dbschema.ppc.tables.Phrases.PHRASES;

/*
SELECT
    row.name,
    count(*) AS count
FROM binlog_rows
ARRAY JOIN row.name
WHERE (date = '2017-04-19') AND (db = 'ppc') AND (operation = 'UPDATE') AND (table = 'phrases')
GROUP BY row.name
ORDER BY count DESC

┏━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━┓
┃ row.name             ┃    count ┃
┡━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━┩
│ statusBsSynced       │ 62474646 │
├──────────────────────┼──────────┤
│ statusShowsForecast  │ 61935441 │
├──────────────────────┼──────────┤
│ forecastDate         │ 26325131 │
├──────────────────────┼──────────┤
│ LastChange           │ 24772093 │
├──────────────────────┼──────────┤
│ statusModerate       │ 14854984 │
├──────────────────────┼──────────┤
│ is_bs_rarely_loaded  │ 12835997 │
├──────────────────────┼──────────┤
│ statusAutobudgetShow │  7351470 │
├──────────────────────┼──────────┤
│ statusPostModerate   │  4602580 │
├──────────────────────┼──────────┤
│ ContextID            │  4231467 │
├──────────────────────┼──────────┤
│ bid                  │  2808690 │
├──────────────────────┼──────────┤
│ PriorityID           │  2440695 │
├──────────────────────┼──────────┤
│ geo                  │   884839 │
├──────────────────────┼──────────┤
│ mw_id                │    71502 │
├──────────────────────┼──────────┤
│ group_name           │    28361 │
└──────────────────────┴──────────┘
 */

@ParametersAreNonnullByDefault
class AdGroupRowProcessingStrategy extends ModularRowProcessingStrategy {
    AdGroupRowProcessingStrategy(RecordSource recordSource) {
        super(recordSource, new AdGroupPathStrategy(), new FieldsStrategyChain(
                new FilterFieldsStrategy(
                        // время последней модификации условия, завязано на экспорт данных в фокусировщик и в методе
                        // API::GetChanges (обычно время не обновляется при обновлении невидимых параметров баннера)
                        "LastChange",

                        // дата последнего обсчёта прогноза показов в bids скриптом ppcGetAdvqShowsNew.pl
                        "forecastDate",

                        // вероятность загрузки группы в движок БК для показов.
                        "is_bs_rarely_loaded",

                        // результат модерации списка фраз и гео (условия показа)
                        "statusBsSynced",

                        // Указывает на то, проводится ли модерация или с каким результатом завершилась
                        "statusModerate",

                        // состояние прогноза показов в связанных записях таблички bids
                        "statusShowsForecast",

                        // не приостановил ли автобюджет показы условия
                        "statusAutobudgetShow",

                        //id контекста из БК, устарело
                        "ContextID",

                        // id условия из БК, устарело
                        "PriorityID"),
                StringsFromDictStrategy.builder()
                        .withIdField(PHRASES.PID.getName())
                        .with(DictDataCategory.ADGROUP_GEO, PHRASES.GEO.getName())
                        .with(DictDataCategory.ADGROUP_NAME, PHRASES.GROUP_NAME.getName())
                        .build(),
                DeduplicationFieldsStrategy.builder().build()));
    }
}
