package ru.yandex.direct.useractionlog.writer.generator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlog.reader.EnrichedInsertRow;
import ru.yandex.direct.binlog.reader.EnrichedRow;
import ru.yandex.direct.useractionlog.AdGroupId;
import ru.yandex.direct.useractionlog.dict.DictDataCategory;
import ru.yandex.direct.useractionlog.dict.DictRequestsFiller;
import ru.yandex.direct.useractionlog.dict.DictResponsesAccessor;
import ru.yandex.direct.useractionlog.dict.FreshDictValuesFiller;
import ru.yandex.direct.useractionlog.schema.AdId;
import ru.yandex.direct.useractionlog.schema.ObjectPath;

import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

/**
 * Специализируется на таблицах, в которых первичный ключ - идентификатор баннера. Например, ppc.banners.
 */
@ParametersAreNonnullByDefault
public class AdPathStrategy implements ObjectPathStrategy {
    @Override
    public Collection<String> objectPathColumns() {
        return Arrays.asList(BANNERS.BID.getName(), BANNERS.CID.getName());
    }

    @Override
    public void fillDictRequests(EnrichedRow row, DictRequestsFiller dictRequests) {
        // В каждом row есть bid, pid и cid. Для того, чтобы составить полный ObjectPath, нужны либо bid+pid, либо
        // bid+cid. Уникальных cid на порядки меньше, поэтому в словарь лучше обращаться за ними - больше шансов на
        // попадание в различные кеши.
        dictRequests.requireCampaignPath(Util.fieldAsLong(Util.dataForGettingId(row), BANNERS.CID));
    }

    @Override
    public ObjectPath extract(EnrichedRow row, DictResponsesAccessor dictResponsesAccessor) {
        ObjectPath.CampaignPath campaignPath = dictResponsesAccessor.getCampaignPath(
                Util.fieldAsLong(Util.dataForGettingId(row), BANNERS.CID));
        AdGroupId adGroupId = new AdGroupId(Util.fieldAsLong(Util.dataForGettingId(row), BANNERS.PID));
        AdId adId = new AdId(Util.fieldAsLong(Util.dataForGettingId(row), BANNERS.BID));
        return new ObjectPath.AdPath(new ObjectPath.AdGroupPath(campaignPath, adGroupId), adId);
    }

    @Override
    public void fillFreshDictValues(EnrichedRow row, DictResponsesAccessor dictData,
                                    FreshDictValuesFiller freshDictValues) {
        if (row instanceof EnrichedInsertRow) {
            freshDictValues.addAdPath((ObjectPath.AdPath) extract(row, dictData));
        }
    }

    @Override
    public Collection<DictDataCategory> provides() {
        return Collections.singleton(DictDataCategory.AD_PATH);
    }
}
