package ru.yandex.direct.useractionlog.writer.generator;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.useractionlog.schema.RecordSource;

@ParametersAreNonnullByDefault
public class BidBaseRowProcessingStrategy extends ModularRowProcessingStrategy {
    BidBaseRowProcessingStrategy(RecordSource recordSource) {
        super(recordSource, new AdGroupPathStrategy(), new FieldsStrategyChain(
                new FilterFieldsStrategy(
                        // Время последнего изменения
                        "LastChange",
                        // Статус синхронизации с БК
                        "statusBsSynced"
                ),
                DeduplicationFieldsStrategy.builder().build())
        );
    }
}
