package ru.yandex.direct.useractionlog.writer.generator;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.useractionlog.dict.DictDataCategory;
import ru.yandex.direct.useractionlog.schema.RecordSource;

import static ru.yandex.direct.dbschema.ppc.Ppc.PPC;

/*

SELECT
    row.name AS row_name,
    operation,
    count() / 7 AS daily_count ,
    sum(length(row.value)) / 7 AS daily_size_bytes
FROM binlog_rows
ARRAY JOIN
    row.name,
    row.value
WHERE (date >= '2017-08-14') AND (date <= '2017-08-20') AND (db = 'ppc') AND (table = 'camp_options')
GROUP BY
    row.name,
    operation
ORDER BY
    row.name ASC,
    operation ASC


-- 78 rows in set. Elapsed: 1.660 sec. Processed 8.48 million rows, 2.41 GB (5.11 million rows/s., 1.45 GB/s.)


┌─row_name───────────────────────┬─operation─┬────────daily_count─┬───daily_size_bytes─┐
│ FIO                            │ INSERT    │ 18193.714285714294 │  443988.5714285714 │
│ FIO                            │ UPDATE    │                542 │ 31812.428571428572 │
│ auto_optimize_request          │ INSERT    │ 18193.714285714294 │  36389.14285714287 │
│ autobudget_roi_coef            │ INSERT    │ 18193.714285714294 │                  0 │
│ autobudget_roi_coef            │ UPDATE    │  4.571428571428571 │  13.14285714285714 │
│ autobudget_roi_params          │ INSERT    │ 18193.714285714294 │                  0 │
│ autobudget_roi_params          │ UPDATE    │                  3 │                 70 │
│ banners_per_page               │ INSERT    │ 18193.714285714294 │ 20259.571428571424 │
│ banners_per_page               │ UPDATE    │  10895.14285714286 │ 24985.857142857138 │
│ broad_match_flag               │ INSERT    │ 18193.714285714294 │  36986.14285714287 │
│ broad_match_flag               │ UPDATE    │ 10551.285714285712 │ 29191.285714285717 │
│ broad_match_goal_id            │ INSERT    │ 18193.714285714294 │ 18248.857142857138 │
│ broad_match_goal_id            │ UPDATE    │ 509.57142857142856 │ 393.57142857142856 │
│ broad_match_limit              │ INSERT    │ 18193.714285714294 │ 19634.714285714294 │
│ broad_match_limit              │ UPDATE    │ 13954.571428571431 │  25801.14285714286 │
│ broad_match_rate               │ INSERT    │ 18193.714285714294 │ 109162.28571428574 │
│ camp_description               │ INSERT    │ 298.71428571428567 │                  0 │
│ camp_description               │ UPDATE    │  3829.428571428571 │ 31064.571428571424 │
│ competitors_domains            │ INSERT    │  2216.428571428571 │                  0 │
│ competitors_domains            │ UPDATE    │ 0.7142857142857144 │                  0 │
│ contactinfo                    │ INSERT    │  2216.428571428571 │  735668.8571428572 │
│ contactinfo                    │ UPDATE    │  8326.428571428569 │            5707439 │
│ content_lang                   │ INSERT    │ 18193.714285714294 │                  0 │
│ create_time                    │ INSERT    │ 18193.714285714294 │             382068 │
│ day_budget_daily_change_count  │ INSERT    │ 18193.714285714294 │ 18193.714285714294 │
│ day_budget_daily_change_count  │ UPDATE    │ 27008.571428571424 │ 27008.571428571424 │
│ day_budget_notification_status │ INSERT    │ 18193.714285714294 │  90968.57142857145 │
│ day_budget_notification_status │ UPDATE    │              32172 │ 144754.85714285713 │
│ day_budget_stop_time           │ INSERT    │ 18193.714285714294 │             382068 │
│ day_budget_stop_time           │ UPDATE    │  35918.28571428572 │             754284 │
│ device_targeting               │ INSERT    │ 18193.714285714294 │                  0 │
│ email                          │ INSERT    │ 18193.714285714294 │ 405198.42857142864 │
│ email                          │ UPDATE    │  868.2857142857143 │ 18127.571428571424 │
│ email_notifications            │ INSERT    │ 18193.714285714294 │  679255.4285714285 │
│ email_notifications            │ UPDATE    │  5236.857142857143 │ 101739.42857142855 │
│ enabled_sms                    │ INSERT    │ 18193.714285714294 │  36387.42857142859 │
│ fairAuction                    │ INSERT    │ 18193.714285714294 │              37198 │
│ fairAuction                    │ UPDATE    │  4376.857142857143 │ 12923.857142857143 │
│ is_related_keywords_enabled    │ INSERT    │ 18193.714285714294 │ 18193.714285714294 │
│ is_search_stop                 │ INSERT    │ 18193.714285714294 │ 18193.714285714294 │
│ is_search_stop                 │ UPDATE    │  4370.714285714284 │  4370.714285714284 │
│ last_pay_time                  │ INSERT    │ 18193.714285714294 │                  0 │
│ last_pay_time                  │ UPDATE    │  893537.8571428572 │           25019060 │
│ lastnews                       │ INSERT    │ 18193.714285714294 │ 18193.714285714294 │
│ manual_autobudget_sum          │ INSERT    │ 18193.714285714294 │ 58.714285714285715 │
│ mediaplan_status               │ INSERT    │ 18193.714285714294 │              72776 │
│ mediaplan_status               │ UPDATE    │  57.14285714285715 │  409.1428571428572 │
│ minus_words                    │ INSERT    │  2216.428571428571 │ 12842966.142857144 │
│ minus_words                    │ UPDATE    │ 18792.428571428572 │ 155229663.57142854 │
│ mobile_multiplier_pct          │ INSERT    │ 18193.714285714294 │                  0 │
│ money_warning_value            │ INSERT    │ 18193.714285714294 │  36382.57142857142 │
│ money_warning_value            │ UPDATE    │ 357.57142857142856 │ 456.57142857142856 │
│ offlineStatNotice              │ INSERT    │ 18193.714285714294 │ 53455.714285714275 │
│ offlineStatNotice              │ UPDATE    │  8816.285714285712 │ 17637.857142857138 │
│ sendAccNews                    │ INSERT    │ 18193.714285714294 │  54306.57142857142 │
│ sendAccNews                    │ UPDATE    │ 8178.4285714285725 │ 16357.428571428569 │
│ sendNews                       │ INSERT    │ 18193.714285714294 │              54397 │
│ sendWarn                       │ INSERT    │ 18193.714285714294 │  54473.42857142859 │
│ sendWarn                       │ UPDATE    │ 11814.571428571431 │ 23665.571428571424 │
│ sms_flags                      │ INSERT    │ 18193.714285714294 │  93.71428571428572 │
│ sms_flags                      │ UPDATE    │               1252 │ 56334.714285714275 │
│ sms_time                       │ INSERT    │ 18193.714285714294 │ 200130.85714285713 │
│ sms_time                       │ UPDATE    │ 16041.428571428569 │ 176455.71428571432 │
│ statusContextStop              │ INSERT    │ 18193.714285714294 │ 37060.714285714275 │
│ statusContextStop              │ UPDATE    │  9550.571428571431 │              26085 │
│ statusMetricaControl           │ INSERT    │ 18193.714285714294 │ 37635.857142857145 │
│ statusMetricaControl           │ UPDATE    │               6728 │              20028 │
│ statusPostModerate             │ INSERT    │ 18193.714285714294 │  73727.42857142855 │
│ statusPostModerate             │ UPDATE    │ 14904.285714285712 │              98125 │
│ status_click_track             │ INSERT    │ 18193.714285714294 │ 18193.714285714294 │
│ status_click_track             │ UPDATE    │ 10239.714285714288 │ 10239.714285714288 │
│ stopTime                       │ INSERT    │ 18193.714285714294 │             382068 │
│ stopTime                       │ UPDATE    │ 58344.714285714275 │            1225239 │
│ strategy                       │ INSERT    │ 18193.714285714294 │              12668 │
│ strategy                       │ UPDATE    │ 5582.4285714285725 │  76119.57142857145 │
│ valid                          │ INSERT    │ 18193.714285714294 │ 18193.714285714294 │
│ warnPlaceInterval              │ INSERT    │ 18193.714285714294 │  36387.42857142859 │
│ warnPlaceInterval              │ UPDATE    │  5343.857142857143 │ 10687.714285714288 │
└────────────────────────────────┴───────────┴────────────────────┴────────────────────┘


График из CSV:

from matplotlib import pyplot
import pandas as pd
df = pd.read_csv('file.csv',
                 names=['Field', 'Operation', 'Count', 'Bytes'])
fig, axes = pyplot.subplots(nrows=1, ncols=2)
for i, (base, col) in enumerate([(10, 'Count'), (2, 'Bytes')]):
    df.pivot(index='Field', columns='Operation', values=col) \
      .loc[sorted(set(df.Field), reverse=True, key=str.lower)] \
      .plot.barh(stacked=True, ax=axes[i])
    axes[i].set_title('Avg Daily ' + col)
    axes[i].set_xscale('log', basex=base)
    if i != 0:
        axes[i].set_ylabel("")
pyplot.show()


Наибольшее количество изменений:

* last_pay_time - миллион записей в сутки
* stopTime - десятки тысяч записей в сутки
* day_budget_* - десятки тысяч записей в сутки у каждой

Наибольший объём изменений:

* minus_words - пара сотен мегабайт в сутки. В поле человекочитаемый текст, который хорошо жмётся.
* last_pay_time - десятки мегабайт в сутки
* contactinfo - десятки мегабайт в сутки
* stopTime - пара мегабайт в сутки

 */

@ParametersAreNonnullByDefault
class CampOptionsRowProcessingStrategy extends ModularRowProcessingStrategy {
    CampOptionsRowProcessingStrategy(RecordSource recordSource) {
        super(recordSource, new CampaignRelatedPathStrategy(), new FieldsStrategyChain(
                // От minus_words избавиться нельзя, last_pay_time теоретически может пригодиться, остальные поля весят
                // слишком мало, чтобы о них беспокоиться
                StringsFromDictStrategy.builder()
                        .withIdField(PPC.CAMP_OPTIONS.CID.getName())
                        .with(DictDataCategory.CAMPAIGN_NAME, PPC.CAMPAIGNS.NAME.getName())
                        .doesNotProduceDictValue(DictDataCategory.CAMPAIGN_NAME)
                        .build(),
                CollectionsDiffStrategy.builder()
                        .withIdField(PPC.CAMP_OPTIONS.CID.getName())
                        .withJsonListCategory(DictDataCategory.CAMPAIGN_MINUS_WORDS,
                                PPC.CAMP_OPTIONS.MINUS_WORDS.getName())
                        .build(),
                DeduplicationFieldsStrategy.builder()
                        .withFieldGroup(PPC.CAMP_OPTIONS.BROAD_MATCH_FLAG.getName(),
                                PPC.CAMP_OPTIONS.BROAD_MATCH_GOAL_ID.getName(),
                                PPC.CAMP_OPTIONS.BROAD_MATCH_LIMIT.getName(),
                                PPC.CAMP_OPTIONS.BROAD_MATCH_RATE.getName())
                        .build()));
    }
}
