package ru.yandex.direct.useractionlog.writer.generator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlog.reader.EnrichedInsertRow;
import ru.yandex.direct.binlog.reader.EnrichedRow;
import ru.yandex.direct.binlog.reader.MySQLSimpleRowIndexed;
import ru.yandex.direct.useractionlog.CampaignId;
import ru.yandex.direct.useractionlog.ClientId;
import ru.yandex.direct.useractionlog.dict.DictDataCategory;
import ru.yandex.direct.useractionlog.dict.DictResponsesAccessor;
import ru.yandex.direct.useractionlog.dict.FreshDictValuesFiller;
import ru.yandex.direct.useractionlog.schema.ObjectPath;

import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;

/**
 * Специально для таблицы ppc.campaigns, в которой есть cid и ClientID и запись в которой появляется до записи в
 * related-таблицы.
 */
@ParametersAreNonnullByDefault
class CampaignPathStrategy implements ObjectPathStrategy {
    private static final Collection<String> OBJECT_PATH_COLUMNS =
            Collections.unmodifiableCollection(Arrays.asList(CAMPAIGNS.CID.getName(), CAMPAIGNS.CLIENT_ID.getName()));

    private static ObjectPath.CampaignPath getPath(MySQLSimpleRowIndexed row) {
        return new ObjectPath.CampaignPath(new ClientId(row.getByName(CAMPAIGNS.CLIENT_ID.getName())),
                new CampaignId(row.getByName(CAMPAIGNS.CID.getName())));
    }

    @Override
    public Collection<String> objectPathColumns() {
        return OBJECT_PATH_COLUMNS;
    }

    @Override
    public void fillFreshDictValues(EnrichedRow row, DictResponsesAccessor dictData,
                                    FreshDictValuesFiller freshDictValues) {
        if (row instanceof EnrichedInsertRow) {
            freshDictValues.addCampaignPath(getPath(((EnrichedInsertRow) row).getFields()));
        }
    }

    @Override
    public Collection<DictDataCategory> provides() {
        return Collections.singleton(DictDataCategory.CAMPAIGN_PATH);
    }

    @Override
    public ObjectPath extract(EnrichedRow row, DictResponsesAccessor dictResponsesAccessor) {
        return getPath(Util.dataForGettingId(row));
    }
}
