package ru.yandex.direct.useractionlog.writer.generator;

import java.util.Collection;
import java.util.Collections;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlog.reader.EnrichedRow;
import ru.yandex.direct.useractionlog.dict.DictDataCategory;
import ru.yandex.direct.useractionlog.dict.DictRequestsFiller;
import ru.yandex.direct.useractionlog.dict.DictResponsesAccessor;
import ru.yandex.direct.useractionlog.dict.FreshDictValuesFiller;
import ru.yandex.direct.useractionlog.schema.ObjectPath;

import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;

/**
 * Специализируется на таблицах, в которых первичный ключ - идентификатор кампании. Например, ppc.camp_options.
 */
@ParametersAreNonnullByDefault
public class CampaignRelatedPathStrategy implements ObjectPathStrategy {
    private final String column;

    public CampaignRelatedPathStrategy() {
        this(CAMPAIGNS.CID.getName());
    }

    /**
     * @param column Название колонки, в которой хранится campaign id.
     */
    public CampaignRelatedPathStrategy(String column) {
        this.column = column;
    }

    @Override
    public void fillDictRequests(EnrichedRow row, DictRequestsFiller dictRequests) {
        dictRequests.requireCampaignPath(getCampaignId(row));
    }

    private long getCampaignId(EnrichedRow row) {
        return Util.fieldAsLong(Util.dataForGettingId(row), column);
    }

    @Override
    public Collection<String> objectPathColumns() {
        return Collections.singleton(column);
    }

    @Override
    public Collection<DictDataCategory> provides() {
        return Collections.emptyList();
    }

    @Override
    public ObjectPath extract(EnrichedRow row, DictResponsesAccessor dictResponsesAccessor) {
        return dictResponsesAccessor.getCampaignPath(getCampaignId(row));
    }

    @Override
    public void fillFreshDictValues(EnrichedRow row, DictResponsesAccessor dictData,
                                    FreshDictValuesFiller freshDictValues) {
        // Этот класс не создаёт новые словарные данные, он их только запрашивает
    }
}
